//  Created by Allen Ingling on Wed Mar 31 2004.
//  Copyright (c) 2004 New York University. All rights reserved.


/* HipsViewer */

#import <Cocoa/Cocoa.h>
#import "HipsHelpers.h"



@interface HipsMovie : NSObject
{
	//audit ownership issues with any objects.  The should be owned by the movie object and released within dealloc.
	//Otherwise we could make sure that they are autoreleased, but they will be retained in the autorelease
	//pool if we release the movie object.
	
	//luminance scaling stuff
	ScaleModeType				currentScaleMode;
	float						maxMoviePixel;
	float						minMoviePixel;
	BOOL						isPixelMaxMinValid;
	float						scaleL;
	float						offsetL;
	
	BOOL						isMeanPixelLValid;
	float						meanPixelL;
	BOOL						isMeanEdgePixelLValid;
	float						meanPixelEdgeL;
	
	int							numColors;
	BOOL						loopFrames;
	int							numFrames;

	DisplayTargetModeType		targetMode;				//is it a view or a display
	TextureModeType				textureMode;
	CGrafPtr					targetPort;
	CGDirectDisplayID			targetDisplay;
	NSOpenGLContext*			openglContext;
	CGLContextObj				openglContextCG;
	
	NSRect						openglContextRect;
	NSRect						movieRect;
	NSRect						targetRect;
	
	float						fps;
	//pointers to stuff we need to deallocate
	NSString					*fullFileName;
	NSString					*headerString;
	GLuint						*textureFramesMemory8;				//32-bit ints.
	GLuint						*textureFramesMemory32;
	GLuint						*textureBlitBuffer32;
	GLuint						*textureBlitBuffer8;
	float						*floatMovieMemory;
	//new  for version 0.5
	id							appObject;
	BOOL						useProgressBars;
	NSWindow					*progressWindow;
	NSProgressIndicator			*progressBar;
	NSTextField					*progressText;
	BOOL						isMovieColor;
	//new for version 0.6
	GLuint						textureNumber8;
	GLuint						textureNumber32;
}
 - (id)init;
 - (void)blitFrame32:(int)frameNumber;
 - (void)blitFrame8:(int)frameNumber;
 - (void)waitForBlank;

// - (void)resetClampRule:(ScaleModeType)ScaleMode;
 - (void)loadFloatFramesBufferFromHipsFile:(NSString*)fileName;
 - (void)load32BitTexturesFromHipsFloatFrames:(ScaleModeType)ScaleMode;
 - (void)instantiate32BitTexturesIntoNSGLContext:(NSOpenGLContext*)context frameSize:(NSRect)contextRect; 
 - (void)instantiate8BitTexturesIntoNSGLContext:(NSOpenGLContext*)context frameSize:(NSRect)contextRect;
 - (void)releaseTexturesFromContext;
 - (void)load8BitTexturesFromHipsFloatFrames:(ScaleModeType)ScaleMode;
 - (void)deallocMovie;
 - (ScaleModeType)getScalingMode;
 - (void)enableProgressBars:(id)caller window:(NSWindow*)theWindow  bar:(NSProgressIndicator*)theBar text:(NSTextField*)theText;
 - (void)disableProgressBars;
 - (void)activateProgressBar:(ProgressActivityType)activity;
 - (float)getMeanPixelValue;
 - (float)getMeanEdgePixelValue;
 - (BOOL)getMovieColorFlag;
 - (int)getNumFrames;
 - (float)getFrameRate;			  
 - (NSRect)getMovieRect;
 - (NSRect)getTargetRect;
 - (void)setFullFileName:(NSString*)newFileName;					//creates an internal copy retained by the movie object
 - (NSString*)getFullFileName;										//returns a string owned by the movie object.
 - (NSString*)getHeaderString;
 - (void)dealloc;
 
@end

